# Generated by Django 3.1.2 on 2021-02-19 05:54

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('apiTest', '0002_auto_20210219_1354'),
    ]

    operations = [
        migrations.CreateModel(
            name='Case',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='用例名称')),
                ('description', models.CharField(blank=True, max_length=1024, null=True, verbose_name='描述')),
                ('create_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
            ],
            options={
                'verbose_name': '自动化测试用例',
                'verbose_name_plural': '自动化测试用例',
                'db_table': 'fusion_case',
            },
        ),
        migrations.CreateModel(
            name='CaseRunRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now=True, verbose_name='运行时间')),
                ('case', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='case.case', verbose_name='所属用例')),
            ],
            options={
                'verbose_name': '用例运行记录',
                'verbose_name_plural': '用例运行记录',
                'db_table': 'fusion_case_run_record',
                'ordering': ['-create_time'],
            },
        ),
        migrations.CreateModel(
            name='CaseApiRunRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, verbose_name='api名称')),
                ('url', models.CharField(max_length=200, verbose_name='请求的url！')),
                ('http_method', models.CharField(choices=[('POST', 'POST'), ('GET', 'GET'), ('PUT', 'PUT'), ('DELETE', 'DELETE')], max_length=10, verbose_name='请求方式')),
                ('headers', models.TextField(null=True, verbose_name='请求头')),
                ('data', models.TextField(null=True, verbose_name='提交的数据')),
                ('create_time', models.DateTimeField(auto_now=True, verbose_name='运行的时间')),
                ('return_code', models.CharField(max_length=10, verbose_name='响应状态码')),
                ('return_content', models.TextField(null=True, verbose_name='响应内容')),
                ('return_time', models.CharField(max_length=1000, verbose_name='响应时间')),
                ('api', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='apiTest.api', verbose_name='关联的API')),
                ('case_record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='api_records', to='case.caserunrecord', verbose_name='关联的case_record')),
            ],
            options={
                'verbose_name': 'Case API运行记录',
                'verbose_name_plural': 'Case API运行记录',
                'db_table': 'fusion_case_api_run_record',
            },
        ),
        migrations.CreateModel(
            name='CaseApiList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('index', models.IntegerField(null=True, verbose_name='执行顺序')),
                ('reset_data', models.TextField(blank=True, null=True, verbose_name='提交的数据')),
                ('reset_expect_content', models.CharField(blank=True, max_length=200, null=True, verbose_name='期望返回的内容')),
                ('reset_expect_data', models.CharField(blank=True, max_length=200, null=True, verbose_name='请求参数')),
                ('reset_expect_code', models.CharField(blank=True, max_length=200, null=True, verbose_name='响应状态码')),
                ('api', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='apiTest.api')),
                ('case', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='case.case')),
            ],
            options={
                'verbose_name': '测试用例中的api',
                'verbose_name_plural': '测试用例中的api',
                'db_table': 'fusion_case_api_list',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='case',
            name='api_list',
            field=models.ManyToManyField(related_name='case_list', through='case.CaseApiList', to='apiTest.Api'),
        ),
    ]
