

package com.smart.hospital.admin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.smart.hospital.admin.api.entity.SysFile;
import com.smart.hospital.common.core.util.R;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 文件管理
 *
 * @author Luckly
 * @date 2019-06-18 17:18:42
 */
public interface SysFileService extends IService<SysFile> {

	/**
	 * 上传文件
	 *
	 * @param file
	 * @return
	 */
	R uploadFile(MultipartFile file);

	/**
	 * 读取文件
	 *
	 * @param fileName
	 * @param response
	 */
	void getFile(String fileName, HttpServletResponse response);

	/**
	 * 删除文件
	 *
	 * @param id
	 * @return
	 */
	Boolean deleteFile(Long id);
}
