package com.smart.hospital.admin.handler;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.smart.hospital.admin.api.dto.UserInfo;
import com.smart.hospital.admin.api.entity.SysSocialDetails;
import com.smart.hospital.admin.api.entity.SysUser;
import com.smart.hospital.admin.mapper.SysSocialDetailsMapper;
import com.smart.hospital.admin.service.SysUserService;
import com.smart.hospital.common.core.constant.SecurityConstants;
import com.smart.hospital.common.core.constant.enums.LoginTypeEnum;
import com.smart.hospital.common.data.tenant.TenantContextHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service("WX_APPLET")
@AllArgsConstructor
public class WechatAppletLoginHandler extends AbstractLoginHandler {

	private final SysSocialDetailsMapper sysSocialDetailsMapper;
	private final SysUserService sysUserService;
	private final RedisTemplate redisTemplate;

	/**
	 * @param code 前端返回，和access_token结合来换取手机号
	 * @return
	 */
	@Override
	public String identify(String code) {
		Object token = redisTemplate.opsForValue().get(SecurityConstants.WX_ACCESS_TOKEN_PREFIX);
		if (token == null || StrUtil.isBlank(token.toString())) {
			SysSocialDetails condition = new SysSocialDetails();
			condition.setType(LoginTypeEnum.WX_APPLET.getType());
			SysSocialDetails socialDetails = sysSocialDetailsMapper.selectOne(new QueryWrapper<>(condition));
			// 获取access_token : {"access_token":"ACCESS_TOKEN","expires_in":7200}
			String url = String.format(SecurityConstants.WX_APPLET_TOKEN_URL, socialDetails.getAppId(), socialDetails.getAppSecret());
			String result = HttpUtil.get(url);
			log.debug("微信获取token响应报文:{}", result);
			token = JSONUtil.parseObj(result).getStr("access_token");
			redisTemplate.opsForValue().set(SecurityConstants.WX_ACCESS_TOKEN_PREFIX, token, 7000L, TimeUnit.SECONDS);
		}
		// 获取手机号
		String url = String.format(SecurityConstants.WX_PHONE_URL, token);
		String resBody = HttpUtil.post(url, MapUtil.<String, Object>builder().put("code", code).build());
		log.debug("微信获取手机号响应报文:{}", resBody);
		return JSONUtil.parseObj(resBody).getJSONObject("phone_info").getStr("phoneNumber");
	}

	@Override
	public UserInfo info(String phone) {
		SysUser user = sysUserService
				.getOne(Wrappers.<SysUser>query()
						.lambda().eq(SysUser::getPhone, phone));
		if (user == null) {
			log.info("用户首次登录:{}", phone);
			// 创建用户
			user = new SysUser();
			user.setPhone(phone);
			user.setDeptId(0);
			user.setUsername(phone);
			user.setPassword("noop");
			Integer tenantId = TenantContextHolder.getTenantId();
			user.setHospitalId(tenantId == null ? 1 : tenantId);
			sysUserService.save(user);
		}
		return sysUserService.findUserInfo(user);
	}
}
