package com.smart.hospital.admin.controller.upms;

import cn.hutool.core.util.RandomUtil;
import com.smart.hospital.common.core.util.R;
import com.smart.hospital.common.im.client.ImClient;
import com.smart.hospital.common.im.msg.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(value = "腾讯IM", tags = {"腾讯IM"})
@RestController
@AllArgsConstructor
@RequestMapping("/im")
public class ImController {

	@Autowired
	ImClient imClient;

	@ApiOperation(value = "发送IM单聊消息")
	@GetMapping(value = "/sendMsg")
	public R sendMsg(@ApiParam(value = "发送内容", name = "text", required = true) @RequestParam String text) {
		SendMsgRequest msgRequest = new SendMsgRequest();
		msgRequest.setSyncOtherMachine(false);
		msgRequest.setToAccount("000076");
		msgRequest.setMsgRandom(RandomUtil.randomInt(6));
		// 消息内容
		TimTextMsgContent content = new TimTextMsgContent();
		content.setText(text);
		// 消息体
		TimTextMsg timTextMsg = new TimTextMsg(MsgType.TIMTextElem);
		timTextMsg.setMsgContent(content);
		// 设置消息内容
		msgRequest.addMsgBody(timTextMsg);
		SendMsgResponse msgResponse = imClient.execute(msgRequest);
		return R.ok(msgResponse);
	}
}
