package com.smart.hospital.admin.api.constant.factory;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.smart.hospital.admin.api.constant.enums.Order;
import com.smart.hospital.common.core.util.WebUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 分页参数构建类
 *
 * @param <T>
 */
public class PageFactory<T> {

	/**
	 * 起始页
	 */
	private static String PAGE_PARAM = "page";

	/**
	 * 页面大小
	 */
	private static String SIZE_PARAM = "pageSize";

	/**
	 * 排序字段名称
	 */
	private static String SORT_PARAM = "sort";

	/**
	 * 升序或者降序
	 */
	private static String ORDER_PARAM = "order";

	/**
	 * 获取默认页面
	 *
	 * @return
	 */
	public Page<T> defaultPage() {
		HttpServletRequest request = WebUtils.getRequest();
		Integer page = Convert.toInt(request.getParameter(PAGE_PARAM), 1);
		Integer pageSize = Convert.toInt(request.getParameter(SIZE_PARAM), 10);
		String sort = request.getParameter(SORT_PARAM);
		String order = request.getParameter(ORDER_PARAM);
		Page<T> pg = new Page<>(page, pageSize);
		if (StrUtil.isNotBlank(sort)) {
			if (Order.ASC.getDes().equals(order)) {
				pg.setAsc(sort);
			} else {
				pg.setDesc(sort);
			}
			return pg;
		}
		return pg;
	}
}
