package com.smart.hospital.register.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * <p>
 * 就诊人关系表
 * </p>
 *
 * @author yuzhiqiang
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("gh_patient_relation")
@ApiModel(value="GhPatientRelation对象", description="就诊人关系表")
public class GhPatientRelation extends Model<GhPatientRelation> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "医院ID")
    private Long hospitalId;

    @ApiModelProperty(value = "微信用户ID")
    private Long userId;

    @ApiModelProperty(value = "就诊卡号")
    private String cardNo;

    @ApiModelProperty(value = "关系id(tb_relation表)")
    private Integer relationId;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @Override
    protected Serializable pkVal() {
        return null;
    }

}
