package com.smart.hospital.register.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * <p>
 * 
 * </p>
 *
 * @author yuzhiqiang
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("gh_patient_card")
@ApiModel(value="GhPatientCard对象", description="")
public class GhPatientCard extends Model<GhPatientCard> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "医院ID")
    private Long hospitalId;

    @ApiModelProperty(value = "医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "就诊卡卡号")
    private String cardNo;

    @ApiModelProperty(value = "HIS系统的就诊人ID0")
    private String patientId;

    @ApiModelProperty(value = "就诊人姓名")
    private String patientName;

    @ApiModelProperty(value = "证件号")
    private String certNo;

    @ApiModelProperty(value = "出生日期")
    private String birthday;

    @ApiModelProperty(value = "男:1，女:2")
    private Integer sex;

    @ApiModelProperty(value = "手机号码")
    private String phone;

    @ApiModelProperty(value = "就诊人地址")
    private String address;

    @ApiModelProperty(value = "二维码地址")
    private String qrcode;

    @ApiModelProperty(value = "条形码地址")
    private String barcode;

    @ApiModelProperty(value = "绑定状态(1:成功，0:失败, -1:解绑)")
    private Integer status;

    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createTime;

    @Override
    protected Serializable pkVal() {
        return null;
    }

}
