

package com.smart.hospital.common.security.exception;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.smart.hospital.common.security.component.SmartAuth2ExceptionSerializer;
import org.springframework.http.HttpStatus;

/**
 * @author giaogiao
 * @date 2018/7/8
 */
@JsonSerialize(using = SmartAuth2ExceptionSerializer.class)
public class ServerErrorException extends SmartAuth2Exception {

	public ServerErrorException(String msg, Throwable t) {
		super(msg);
	}

	@Override
	public String getOAuth2ErrorCode() {
		return "server_error";
	}

	@Override
	public int getHttpErrorCode() {
		return HttpStatus.INTERNAL_SERVER_ERROR.value();
	}

}
