

package com.smart.hospital.common.security.component;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.smart.hospital.common.core.constant.CommonConstants;
import com.smart.hospital.common.security.exception.SmartAuth2Exception;
import lombok.SneakyThrows;

/**
 * @author giaogiao
 * @date 2018/11/16
 * <p>
 * OAuth2 异常格式化
 */
public class SmartAuth2ExceptionSerializer extends StdSerializer<SmartAuth2Exception> {
	public SmartAuth2ExceptionSerializer() {
		super(SmartAuth2Exception.class);
	}

	@Override
	@SneakyThrows
	public void serialize(SmartAuth2Exception value, JsonGenerator gen, SerializerProvider provider) {
		gen.writeStartObject();
		gen.writeObjectField("code", CommonConstants.FAIL);
		gen.writeStringField("msg", value.getMessage());
		gen.writeStringField("data", value.getErrorCode());
		gen.writeEndObject();
	}
}
