package com.smart.hospital.common.pay.strategy.handler;

import cn.hutool.json.JSONUtil;
import com.smart.hospital.common.pay.core.wx.WxPayApi;
import com.smart.hospital.common.pay.enums.PaymentMethod;
import com.smart.hospital.common.pay.exception.PayException;
import com.smart.hospital.common.pay.model.WxHttpResponse;
import com.smart.hospital.common.pay.model.WxRefundModel;
import com.smart.hospital.common.pay.prop.WxPayV3Properties;
import com.smart.hospital.common.pay.source.PayAttribute;
import com.smart.hospital.common.pay.util.WxPayKit;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class WxRefundStrategyHandler extends AbstractStrategyHandler {

	public WxRefundStrategyHandler(WxPayV3Properties wxPayV3Properties) {
		super(wxPayV3Properties);
	}

	public WxRefundStrategyHandler() {
	}

	@Override
	public Object execute(PayAttribute attribute, Object... params) throws Exception {
		Object param = params[0];
		log.info("退款参数 {}", param);
		WxRefundModel refundModel = (WxRefundModel) param;
		refundModel.setNotify_url(getWxPayV3Properties().getDomain().concat("/v3/refundNotify"));
		WxHttpResponse response = WxPayApi.v3(
				attribute.getRequestMethod(),
				attribute.getPrefix().getType(),
				attribute.getSuffix().getType(),
				getWxPayV3Properties().getMchId(),
				getSerialNumber(),
				null,
				getWxPayV3Properties().getKeyPath(),
				JSONUtil.toJsonStr(refundModel)
		);
		if (response.getStatus() == OK) {
			// 根据证书序列号查询对应的证书来验证签名结果
			boolean verifySignature = WxPayKit.verifySignature(response, getWxPayV3Properties().getPlatformCertPath());
			log.info("verifySignature: {}", verifySignature);
			log.info("退款响应 {}", response);
			if (verifySignature) {
				return response.getBody();
			}
		}

		throw new PayException("退款失败!");
	}

	@Override
	public boolean apply(PayAttribute attribute) {
		return attribute.getPayment() == PaymentMethod.WX_REFUND;
	}
}
