package com.smart.hospital.common.pay.strategy.handler;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.smart.hospital.common.pay.constant.Version;
import com.smart.hospital.common.pay.core.wx.WxPayApi;
import com.smart.hospital.common.pay.enums.PaymentMethod;
import com.smart.hospital.common.pay.exception.PayException;
import com.smart.hospital.common.pay.model.WxHttpResponse;
import com.smart.hospital.common.pay.model.WxUnifiedOrderModel;
import com.smart.hospital.common.pay.prop.WxPayV3Properties;
import com.smart.hospital.common.pay.source.PayAttribute;
import com.smart.hospital.common.pay.util.WxPayKit;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * 微信jsapi-v3支付
 */
@Slf4j
public class WxJsapiV3StrategyHandler extends AbstractStrategyHandler {

	public WxJsapiV3StrategyHandler(WxPayV3Properties wxPayV3Properties) {
		super(wxPayV3Properties);
	}

	public WxJsapiV3StrategyHandler() {
	}

	@Override
	public Object beforeExecute(PayAttribute attribute, Class<?> clientInterface, Method method, Object[] args) {
		return null;
	}

	@Override
	public Object execute(PayAttribute attribute, Object... params) throws Exception {
		Object param = params[0];
		log.info("统一下单参数 {}", JSONUtil.toJsonStr(param));
		WxUnifiedOrderModel model = null;
		if (param instanceof WxUnifiedOrderModel) {
			model = (WxUnifiedOrderModel) param;
			model.setAppid(getWxPayV3Properties().getAppId())
					.setMchid(getWxPayV3Properties().getMchId())
					.setNotify_url(getWxPayV3Properties().getDomain().concat("/v3/payNotify"))
//					.setTime_expire(timeExpire)
			;
		}
		if (model == null) {
			throw new PayException("参数错误");
		}
		WxHttpResponse response = WxPayApi.v3(attribute.getRequestMethod(),
				attribute.getPrefix().getType(),
				attribute.getSuffix().getType(),
				getWxPayV3Properties().getMchId(),
				getSerialNumber(),
				null,
				getWxPayV3Properties().getKeyPath(),
				JSONUtil.toJsonStr(model));
		if (response.getStatus() == OK) {
			// 根据证书序列号查询对应的证书来验证签名结果
			boolean verifySignature = WxPayKit.verifySignature(response, getWxPayV3Properties().getPlatformCertPath());
			log.info("verifySignature: {}", verifySignature);
			if (verifySignature) {
				String body = response.getBody();
				JSONObject jsonObject = JSONUtil.parseObj(body);
				String prepayId = jsonObject.getStr("prepay_id");
				Map<String, String> map = WxPayKit.jsApiCreateSign(getWxPayV3Properties().getAppId(), prepayId, getWxPayV3Properties().getKeyPath());
				log.info("唤起支付参数:{}", map);
				return JSONUtil.toJsonStr(map);
			}
		}
		throw new PayException("调用" + attribute.getPayment().getDescribe() + "失败!");
	}

	@Override
	public boolean apply(PayAttribute attribute) {
		return attribute.getPayment() == PaymentMethod.WX_JSAPI && Version.WX_V3.equals(attribute.getVersion());
	}
}
