package com.smart.hospital.common.pay.strategy.handler;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.smart.hospital.common.pay.prop.WxPayV3Properties;
import com.smart.hospital.common.pay.util.PayKit;

import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractStrategyHandler implements StrategyHandler {

	protected final int OK = 200;

	private WxPayV3Properties wxPayV3Properties;

	private final Map<String, String> localCache = new ConcurrentHashMap<>(16);

	public AbstractStrategyHandler(WxPayV3Properties wxPayV3Properties) {
		this.wxPayV3Properties = wxPayV3Properties;
	}

	public AbstractStrategyHandler() {
	}

	protected String getSerialNumber() {
		String num = localCache.get(wxPayV3Properties.getAppId());
		if (StrUtil.isNotBlank(num)) {
			return num;
		}
		// 获取证书序列号
		X509Certificate certificate = PayKit.getCertificate(FileUtil.getInputStream(wxPayV3Properties.getCertPath()));
		String serialNo = certificate.getSerialNumber().toString(16).toUpperCase();
		localCache.put(wxPayV3Properties.getAppId(), serialNo);
		return serialNo;
	}

	public WxPayV3Properties getWxPayV3Properties() {
		return wxPayV3Properties;
	}

	@Override
	public void setProperties(WxPayV3Properties wxPayV3Properties) {
		this.wxPayV3Properties = wxPayV3Properties;
	}
}
