package com.smart.hospital.common.pay.strategy.factory;


import com.smart.hospital.common.pay.source.PayAttribute;
import com.smart.hospital.common.pay.strategy.handler.StrategyHandler;

import java.util.List;

public class StrategyHandlerFactory implements StrategyFactory {

	private final List<StrategyHandler> strategyHandlers;

	public StrategyHandlerFactory(List<StrategyHandler> strategyHandlers) {
		this.strategyHandlers = strategyHandlers;
	}

	@Override
	public StrategyHandler canApply(PayAttribute attribute) {
		if (strategyHandlers == null || strategyHandlers.isEmpty()) {
			return null;
		}
		for (StrategyHandler strategyHandler : strategyHandlers) {
			if (strategyHandler.apply(attribute)) {
				return strategyHandler;
			}
		}
		return null;
	}
}
