package com.smart.hospital.common.pay.strategy;

import com.smart.hospital.common.pay.source.PayAttribute;
import com.smart.hospital.common.pay.strategy.builder.HandlerFactoryBuilder;
import com.smart.hospital.common.pay.strategy.factory.StrategyFactory;
import com.smart.hospital.common.pay.strategy.handler.StrategyHandler;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

@Slf4j
public abstract class AbstractPayStrategy implements PayStrategy {

	private HandlerFactoryBuilder factoryBuilder;

	@Override
	public StrategyHandler getHandler(PayAttribute attribute) {
		StrategyFactory factory = factoryBuilder.build();
		return factory.canApply(attribute);
	}

	@Override
	public Object wrap(Class<?> clientInterface, Method method, Object arg) {
		return arg;
	}

	protected boolean check(Object arg) {
		return true;
	}

	public HandlerFactoryBuilder getFactoryBuilder() {
		return factoryBuilder;
	}

	public void setFactoryBuilder(HandlerFactoryBuilder factoryBuilder) {
		this.factoryBuilder = factoryBuilder;
	}

}
