package com.smart.hospital.common.pay.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * V3 微信申请退款 Model
 * 参数说明:https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_1_9.shtml
 */
@Data
@Accessors(chain = true)
public class WxRefundModel {
	/**
	 * 微信支付订单号
	 */
	private String transaction_id;
	/**
	 * 商户订单号
	 */
	private String out_trade_no;
	/**
	 * 商户退款单号
	 */
	private String out_refund_no;
	/**
	 * 退款原因
	 */
	private String reason;
	/**
	 * 退款结果回调url
	 */
	private String notify_url;
	/**
	 * 退款资金来源
	 */
	private String funds_account;
	/**
	 * 金额信息
	 */
	private WxRefundAmount amount;
	/**
	 * 退款商品
	 */
	private List<WxRefundGoodsDetail> goods_detail;
}


