package com.smart.hospital.common.pay.factory;

import com.smart.hospital.common.pay.source.PayAttributeSource;
import com.smart.hospital.common.pay.strategy.PayStrategy;

import java.lang.reflect.Proxy;

public class PayProxyFactory<T> {

	private final Class<T> clientInterface;

	public PayProxyFactory(Class<T> clientInterface) {
		this.clientInterface = clientInterface;
	}

	@SuppressWarnings("unchecked")
	protected T newInstance(PayClientProxy<T> payClientProxy) {
		return (T) Proxy.newProxyInstance(clientInterface.getClassLoader(), new Class[]{clientInterface}, payClientProxy);
	}

	protected T newInstance(PayAttributeSource payAttributeSource, PayStrategy payStrategy) {
		PayClientProxy<T> payClientProxy = new PayClientProxy<>(clientInterface, payAttributeSource,payStrategy);
		return newInstance(payClientProxy);
	}
}
