package com.smart.hospital.common.pay.config;

import com.smart.hospital.common.pay.source.PayAttributeSource;
import com.smart.hospital.common.pay.strategy.PayStrategy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;


public abstract class AbstractBeanConfigurer implements BeanDefinitionRegistryPostProcessor {

	private String basePackage;

	private PayAttributeSource payAttributeSource;

	private PayStrategy payStrategyManager;

	@Override
	public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
		PayClientRegistryScanner scanner = new PayClientRegistryScanner(registry);
		scanner.setPayAttributeSource(payAttributeSource);
		scanner.setPayStrategy(payStrategyManager);
		scanner.registerFilters();
		scanner.scan(StringUtils.tokenizeToStringArray(this.basePackage, ConfigurableApplicationContext.CONFIG_LOCATION_DELIMITERS));
	}

	@Override
	public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
		// do nothing
	}

	public String getBasePackage() {
		return basePackage;
	}

	public void setBasePackage(String basePackage) {
		this.basePackage = basePackage;
	}

	public PayAttributeSource getPayAttributeSource() {
		return payAttributeSource;
	}

	public void setPayAttributeSource(PayAttributeSource payAttributeSource) {
		this.payAttributeSource = payAttributeSource;
	}

	public PayStrategy getPayStrategyManager() {
		return payStrategyManager;
	}

	public void setPayStrategyManager(PayStrategy payStrategyManager) {
		this.payStrategyManager = payStrategyManager;
	}
}
