package com.smart.hospital.common.mq.handler.confirm;

import com.smart.hospital.common.mq.domin.DefaultMessage;
import com.smart.hospital.common.mq.enums.DeliverStatus;
import com.smart.hospital.common.mq.handler.MessageContentHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CorrelationData;

/**
 * 默认的处理器（message -> Exchange）
 */
@Slf4j
public class DefaultConfirmCallbackHandler extends AbstractConfirmCallbackHandler {

	/**
	 * 消息处理器
	 */
	private final MessageContentHandler messageContentHandler;

	public DefaultConfirmCallbackHandler(MessageContentHandler messageContentHandler) {
		this.messageContentHandler = messageContentHandler;
	}

	@Override
	protected Object successCallback(CorrelationData correlationData) {
		if (correlationData != null) {
			DefaultMessage defaultMessage = (DefaultMessage) messageContentHandler.getMessage(null, null, correlationData.getId());
			defaultMessage.setDeliverStatus(DeliverStatus.DELIVER_SUCCESS.getCode());
			return defaultMessage;
		}
		return null;
	}

	@Override
	protected Object failCallback(CorrelationData correlationData, String cause) {
		log.warn("消息发送到交换机失败:{}", cause);
		if (correlationData != null) {
			DefaultMessage defaultMessage = (DefaultMessage) messageContentHandler.getMessage(null, null, correlationData.getId());
			// 将消息内容改为投递失败
			defaultMessage.setDeliverStatus(DeliverStatus.DELIVER_EXCHANGE_FAIL.getCode());
			return defaultMessage;
		}
		return null;
	}
}
