package com.smart.hospital.common.mq.handler.confirm;

import com.smart.hospital.common.mq.handler.ConfirmCallbackHandler;
import org.springframework.amqp.rabbit.connection.CorrelationData;

public abstract class AbstractConfirmCallbackHandler implements ConfirmCallbackHandler {

	@Override
	public Object confirmCallback(CorrelationData correlationData, boolean ack, String cause) {
		Object result;
		if (ack) {
			result = successCallback(correlationData);
		} else {
			result = failCallback(correlationData, cause);
		}
		return result;
	}

	/**
	 * 成功发送到交换机
	 *
	 * @param correlationData
	 * @return
	 */
	protected abstract Object successCallback(CorrelationData correlationData);

	/**
	 * 失败发送到交换机
	 *
	 * @param correlationData
	 * @param cause
	 * @return
	 */
	protected abstract Object failCallback(CorrelationData correlationData, String cause);
}
