package com.smart.hospital.common.lock.service.impl.zookeeper;

import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.service.LockService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMultiLock;

import java.util.List;

public class ZookeeperMultiZkLockService implements LockService {

	private CuratorFramework zkClient;

	private LockKey<String, List<String>> lockKey;

	private InterProcessMultiLock lock;

	public ZookeeperMultiZkLockService(CuratorFramework zkClient, LockKey<String, List<String>> lockKey) {
		this.zkClient = zkClient;
		this.lockKey = lockKey;
	}

	@Override
	public void lock() throws Exception {
		lock = new InterProcessMultiLock(zkClient, this.lockKey.getLockPath());
		boolean success = lock.acquire(lockKey.getWaitTime(), lockKey.getTimeUnit());
		if (!success) {
			throw new IllegalArgumentException("加锁失败");
		}
	}

	@Override
	public void release() {
		try {
			if (lock.isAcquiredInThisProcess()) {
				lock.release();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
