package com.smart.hospital.common.lock.provider.pattern;

import cn.hutool.core.util.StrUtil;
import com.smart.hospital.common.lock.config.InitConfig;
import com.smart.hospital.common.lock.config.RedisSchemeConfig;
import com.smart.hospital.common.lock.config.redis.RedisSingleConfig;
import com.smart.hospital.common.lock.constant.LockCommonConstant;
import com.smart.hospital.common.lock.enums.ServerPattern;
import lombok.SneakyThrows;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.SslProvider;

import java.net.URL;

public class RedisSingleProvider implements PatternProvider {

	@Override
	@SneakyThrows
	public RedissonClient init(InitConfig baseConfig) {
		SingleServerConfig singleServerConfig = baseConfig.useSingleServer();
		RedisSchemeConfig redisSchemeConfig = baseConfig.getLockProperties().getRedis();
		RedisSingleConfig singleConfig = redisSchemeConfig.getSingleServer();
		// 连接地址
		singleServerConfig.setAddress(String.format("%s%s%s%s", LockCommonConstant.REDIS_URL_PREFIX, singleConfig.getAddress(), LockCommonConstant.COLON, singleConfig.getPort()));
		// 客户端名称
		singleServerConfig.setClientName(redisSchemeConfig.getClientName());

		singleServerConfig.setConnectionMinimumIdleSize(singleConfig.getConnMinIdleSize());
		singleServerConfig.setConnectionPoolSize(singleConfig.getConnPoolSize());
		singleServerConfig.setConnectTimeout(singleConfig.getConnTimeout());
		singleServerConfig.setDatabase(singleConfig.getDatabase());
		singleServerConfig.setDnsMonitoringInterval(singleConfig.getDnsMonitoringInterval());
		singleServerConfig.setIdleConnectionTimeout(singleConfig.getIdleConnTimeout());
		singleServerConfig.setKeepAlive(singleConfig.isKeepAlive());
		singleServerConfig.setPassword(singleConfig.getPassword());
		singleServerConfig.setRetryAttempts(singleConfig.getRetryAttempts());
		singleServerConfig.setRetryInterval(singleConfig.getRetryInterval());
		singleServerConfig.setSslEnableEndpointIdentification(redisSchemeConfig.getSslEnable());

		if (redisSchemeConfig.getSslKeyPath() != null) {
			singleServerConfig.setSslKeystore(new URL(redisSchemeConfig.getSslKeyPath()));
		}
		if (redisSchemeConfig.getSslKeyPassword() != null) {
			singleServerConfig.setSslKeystorePassword(redisSchemeConfig.getSslKeyPassword());
		}
		singleServerConfig.setSslProvider(LockCommonConstant.JDK.equalsIgnoreCase(redisSchemeConfig.getSslProvider()) ? SslProvider.JDK : SslProvider.OPENSSL);
		return Redisson.create(baseConfig);
	}

	@Override
	public boolean supports(String pattern) {
		if (StrUtil.isBlank(pattern)) {
			return false;
		}
		return ServerPattern.SINGLE.getPattern().equals(pattern);
	}

}
