package com.smart.hospital.common.lock.properties;

import com.smart.hospital.common.lock.config.RedisSchemeConfig;
import com.smart.hospital.common.lock.config.ZookeeperSchemeConfig;
import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.enums.ServerPattern;
import org.redisson.client.codec.Codec;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.smart.hospital.common.lock.properties.LockProperties.LOCK_PREFIX;

/**
 * 分布式锁配置类
 */
@ConfigurationProperties(prefix = LOCK_PREFIX)
public class LockProperties {

	public static final String LOCK_PREFIX = "spring.lock";

	public static final String PROPERTY_NAME = "lock-scheme";

	/**
	 * 序列化方式
	 */
	private Codec codec;

	/**
	 * 锁的实现方式,默认redis
	 */
	private String lockScheme = LockScheme.REDIS.getScheme();

	/**
	 * 默认是redis的单机模式
	 */
	private String pattern = ServerPattern.SINGLE.getPattern();

	/**
	 * redis配置
	 */
	private RedisSchemeConfig redis;

	/**
	 * zookeeper配置
	 */
	private ZookeeperSchemeConfig zookeeper;

	public String getLockScheme() {
		return lockScheme;
	}

	public void setLockScheme(String lockScheme) {
		this.lockScheme = lockScheme;
	}

	public String getPattern() {
		return pattern;
	}

	public void setPattern(String pattern) {
		this.pattern = pattern;
	}

	public RedisSchemeConfig getRedis() {
		return redis;
	}

	public void setRedis(RedisSchemeConfig redis) {
		this.redis = redis;
	}

	public Codec getCodec() {
		return codec;
	}

	public void setCodec(Codec codec) {
		this.codec = codec;
	}

	public ZookeeperSchemeConfig getZookeeper() {
		return zookeeper;
	}

	public void setZookeeper(ZookeeperSchemeConfig zookeeper) {
		this.zookeeper = zookeeper;
	}
}
