package com.smart.hospital.common.lock.key.strategy.impl;


import cn.hutool.core.util.ArrayUtil;
import com.smart.hospital.common.lock.advisor.attribute.LockAttribute;
import com.smart.hospital.common.lock.annotation.Key;
import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.key.LockKey;
import com.smart.hospital.common.lock.key.strategy.AbstractKeyStrategy;
import com.smart.hospital.common.lock.key.strategy.KeyStrategy;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

@Slf4j
public class MethodKeyStrategy extends AbstractKeyStrategy {

	public MethodKeyStrategy(String className, String methodName, Method realMethod, Object[] args, LockScheme scheme, LockAttribute attribute) {
		super(className, methodName, realMethod, args, scheme, attribute);
	}

	@Override
	protected void buildKeyItem(LockKey<String, List<String>> lockKey) {
		String[] values = ((Key) realMethod.getAnnotation(KeyStrategy.KEY_ANNOTATION_CLASS)).value();
		if (ArrayUtil.isEmpty(args)) {
			for (String key : values) {
				lockKey.setKey(key);
			}
		} else {
			for (int i = 0; i < args.length; i++) {
				Object arg = args[i];
				Class<?> argClass = arg.getClass();
				Field[] fields = argClass.getDeclaredFields();
				for (String key : values) {
					String[] propertyName = key.split("\\.");
					String[] classNames = argClass.getName().split("\\.");
					if (propertyName[0].equals(classNames[classNames.length - 1])) {
						for (Field field : fields) {
							field.setAccessible(true);
							if (field.getName().equals(propertyName[1])) {
								try {
									lockKey.setKey(wrapKey(field.get(arg).toString()));
								} catch (Exception ex) {
									throw new IllegalArgumentException("构建Key失败", ex);
								}
							}
						}
					}
				}
			}
		}
	}
}
