package com.smart.hospital.common.lock.key;

import com.smart.hospital.common.lock.constant.LockCommonConstant;
import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.enums.LockType;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ZookeeperLockKey implements LockKey<String, List<String>> {

	private LockType lockType;

	private long waitTime = -1;

	private TimeUnit timeUnit = TimeUnit.SECONDS;

	/**
	 * key列表
	 */
	private List<String> keyList;

	public ZookeeperLockKey(LockType lockType, long waitTime, TimeUnit timeUnit, List<String> keyList) {
		this.lockType = lockType;
		this.waitTime = waitTime;
		this.timeUnit = timeUnit;
		this.keyList = keyList;
	}

	@Override
	public List<String> getLockPath() {
		List<String> pathList = new ArrayList<String>();
		for (String key : this.getKey()) {
			pathList.add(LockCommonConstant.OBLIQUE + key.replace(LockCommonConstant.KEY_SPLIT_MARK, LockCommonConstant.OBLIQUE));
		}
		return pathList;
	}

	@Override
	public List<String> getKey() {
		return this.keyList;
	}

	@Override
	public void setKey(String key) {
		if (this.keyList != null) {
			this.keyList.add(key);
		}
		throw new IllegalStateException("Key的存储列表没有被初始化");
	}

	@Override
	public LockScheme getLockScheme() {
		return null;
	}

	@Override
	public LockType getLockType() {
		return this.lockType;
	}

	@Override
	public long getLeaseTime() {
		return -1;
	}

	@Override
	public long getWaitTime() {
		return this.waitTime;
	}

	@Override
	public TimeUnit getTimeUnit() {
		return this.timeUnit;
	}
}
