package com.smart.hospital.common.lock.key;


import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.enums.LockType;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 分布式锁的key信息
 */
public interface LockKey<T, M> {

	/**
	 * 获取key
	 *
	 * @return
	 */
	M getKey();

	/**
	 * 设置Key
	 *
	 * @param key
	 */
	void setKey(T key);

	/**
	 * 获取scheme
	 *
	 * @return
	 */
	LockScheme getLockScheme();

	/**
	 * 获取lockType
	 *
	 * @return
	 */
	LockType getLockType();

	long getLeaseTime();

	long getWaitTime();

	TimeUnit getTimeUnit();

	default List<String> getLockPath() {
		return null;
	}

}
