package com.smart.hospital.common.lock.enums;

/**
 * 锁的实现方式
 */
public enum LockScheme {

	REDIS(LockSchemeConstant.REDIS),

	ZOOKEEPER(LockSchemeConstant.ZOOKEEPER);

	private String scheme;

	LockScheme(String scheme) {
		this.scheme = scheme;
	}

	public String getScheme() {
		return scheme;
	}

	public static LockScheme find(String scheme) {
		if (scheme == null) {
			return null;
		}
		for (LockScheme value : LockScheme.values()) {
			if (value.getScheme().equals(scheme)) {
				return value;
			}
		}
		return null;
	}

	public interface LockSchemeConstant {

		String REDIS = "redis";

		String ZOOKEEPER = "zookeeper";
	}
}
