package com.smart.hospital.common.lock.config;

import com.smart.hospital.common.lock.properties.LockProperties;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;

public class InitConfig extends Config {

	/**
	 * 默认是redis的单机模式
	 */
	private final String pattern;

	/**
	 * 配置信息
	 */
	private final LockProperties lockProperties;

	public String getPattern() {
		return pattern;
	}

	public LockProperties getLockProperties() {
		return lockProperties;
	}

	public InitConfig(String pattern, LockProperties lockProperties, Codec codec) {
		this.pattern = pattern;
		this.lockProperties = lockProperties;
		if (codec != null) {
			this.setCodec(codec);
		}
	}


}
