package com.smart.hospital.common.lock.advisor.parser;

import com.smart.hospital.common.lock.advisor.attribute.LockAttribute;
import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.key.strategy.KeyStrategy;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

/**
 * 分布式锁注解解析器
 */
public interface LockAnnotationParser {

	/**
	 * 解析指定方法或则类的注解信息
	 *
	 * @param element
	 * @return
	 */
	LockAttribute parseLockAnnotation(AnnotatedElement element);

	/**
	 * 从方法获取@Key注解信息
	 *
	 * @param method
	 * @return
	 */
	KeyStrategy parseKeyAnnotation(Method method, Class<?> targetClass, Object[] arguments, LockAttribute attr);

	/**
	 * 获取锁类型 事zookeeper还是redis
	 *
	 * @param realMethod
	 * @return
	 */
	LockScheme getLockScheme(Method realMethod);
}
