package com.smart.hospital.common.lock.advisor.parser;

import com.smart.hospital.common.lock.enums.LockScheme;
import com.smart.hospital.common.lock.key.strategy.KeyStrategy;

import java.lang.reflect.Method;

/**
 * @Key解析类
 */
public interface KeyAnnotationParser {

	/**
	 * 从方法获取@Key注解信息
	 *
	 * @param method
	 * @return
	 */
	KeyStrategy parseKeyAnnotation(Method method, Class<?> targetClass, Object[] arguments);

	/**
	 * 获取锁类型 事zookeeper还是redis
	 *
	 * @param realMethod
	 * @return
	 */
	LockScheme getLockScheme(Method realMethod);
}
