package com.smart.hospital.common.im.client;

import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smart.hospital.common.im.AbstractImRequest;
import com.smart.hospital.common.im.AbstractImResponse;
import com.smart.hospital.common.im.ImConstants;
import com.smart.hospital.common.im.ImException;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;

import java.io.IOException;

/**
 * IM请求客户端
 */
@Slf4j
public class OkHttpImClient extends AbstractImClient {

	OkHttpClient client;

	public OkHttpImClient(ObjectMapper objectMapper, Long sdkAppId, String key, String identifier, OkHttpClient client) {
		super(objectMapper, sdkAppId, key, identifier);
		this.client = client;
	}

	@Override
	protected <T extends AbstractImResponse> T executeWithHttpRequest(AbstractImRequest<T> request, String uri, ObjectMapper objectMapper) {
		Request.Builder builder = new Request.Builder();
		RequestBody body = RequestBody.create(MediaType.parse(ImConstants.DEFAULT_MEDIA_TYPE), request.requestBody(objectMapper));
		builder.url(uri);
		builder.post(body);
		return request.parseResponse(getResponse(builder), objectMapper);
	}

	@SneakyThrows
	public String getResponse(Request.Builder builder) {
		try {
			Response response = client.newCall(builder.build()).execute();
			if (ObjectUtil.isNull(response.body())) {
				throw new ImException("request body is null");
			}
			log.info("请求微信客户端返回的数据为:{}", response);
			return response.body().string();
		} catch (IOException e) {
			throw new ImException("request response error : " + e.getLocalizedMessage());
		}
	}
}
