package com.smart.hospital.common.im.client;

import com.smart.hospital.common.im.AbstractImRequest;
import com.smart.hospital.common.im.AbstractImResponse;
import com.smart.hospital.common.im.ImConstants;
import com.smart.hospital.common.im.ImException;

/**
 * IM请求client接口
 */
public interface ImClient {

	/**
	 * 获取响应对象
	 *
	 * @param request
	 * @param <R>
	 * @return
	 */
	<R extends AbstractImResponse> R getResponse(AbstractImRequest<R> request);

	/**
	 * 执行请求的默认方法
	 *
	 * @param request
	 * @param <R>
	 */
	default <R extends AbstractImResponse> R execute(AbstractImRequest<R> request) {
		R res = getResponse(request);
		if (res == null) {
			throw new ImException("response null");
		}
		if (!ImConstants.CODE_SUCCESS.equals(res.getErrorCode())) {
			throw new ImException("request fail[code=" + res.getErrorCode() + ", msg=" + res.getErrorInfo() + "]");
		}
		return res;
	}
}
