package com.smart.hospital.admin.controller.upms;

import com.smart.hospital.common.core.util.R;
import com.smart.hospital.common.mq.client.RabbitClient;
import com.smart.hospital.common.mq.handler.holder.DefaultMessageContentHandler;
import com.smart.hospital.common.security.annotation.Inner;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("mq")
@Api(value = "mq", tags = "消息队列测试模块")
public class MqController {

	@Autowired
	RabbitClient rabbitClient;
	@Autowired
	DefaultMessageContentHandler messageContentHandler;

	@Inner(value = false)
	@GetMapping(value = "/go")
	public void send() {
		rabbitClient.send("testExchange", "testKey", "this is a msg", "123456");
	}

	@Inner(value = false)
	@GetMapping(value = "/all")
	public R getAllMsg() {
		return R.ok(messageContentHandler.getAllMessages());
	}
}
