package com.smart.hospital.admin.controller.upms;

import com.smart.hospital.common.lock.annotation.Key;
import com.smart.hospital.common.lock.annotation.Lock;
import com.smart.hospital.common.security.annotation.Inner;
import io.swagger.annotations.Api;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("lock")
@Api(value = "lock", tags = "分布式锁测试模块")
public class LockController {

	/**
	 * 事务的提交一定要在解锁之前，要不然锁先释放了，其他线程进来，此时事务可能还没有提交
	 * @param name
	 * @return
	 */
	@Inner(value = false)
	@GetMapping(value = "go")
	@Transactional
	@Lock
	public Object lock(@RequestParam @Key String name) {
		return name;
	}
}
