package com.smart.hospital.admin.controller.hospital;

import com.smart.hospital.admin.api.dto.hospital.HospitalQueryDTO;
import com.smart.hospital.admin.api.vo.hospital.HospitalDetailVO;
import com.smart.hospital.admin.api.vo.hospital.HospitalListVO;
import com.smart.hospital.admin.service.IYyHospitalInfoService;
import com.smart.hospital.common.core.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

@Api(value = "医院/门诊信息", tags = "医院/门诊信息")
@RestController
@RequestMapping(value = "/hospital")
@AllArgsConstructor
public class HospitalController {

	private final IYyHospitalInfoService hospitalInfoService;

	@ApiOperation(value = "查询医院列表", response = HospitalListVO.class)
	@PostMapping(value = "/admin/info/list")
	public R getHospitalInfoList(@RequestBody HospitalQueryDTO hospitalQuery) {
		return R.ok(hospitalInfoService.getHospitalInfoList(hospitalQuery));
	}

	@ApiOperation(value = "医院详情(管理后台)", response = HospitalDetailVO.class)
	@GetMapping(value = "/admin/detail")
	public R getDetailByHospitalId(@ApiParam(value = "医院ID", name = "hospitalId") @RequestParam Long hospitalId) {
		return R.ok(hospitalInfoService.getDetailByHospitalId(hospitalId));
	}
	
}
