package com.smart.hospital.admin.api.vo.hospital;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "微信查询医院详情返回对象")
public class HospitalDetailVO implements Serializable {

	private static final long serialVersionUID = -1684695083154401477L;

	@ApiModelProperty(value = "医院ID")
	private Long hospitalId;

	@ApiModelProperty(value = "医院名称")
	private String hospitalName;

	@ApiModelProperty(value = "医院编码")
	private String hospitalCode;

	@ApiModelProperty(value = "医院logo")
	private String hospitalLogo;

	@ApiModelProperty(value = "医院级别")
	private Integer hospitalLevel;

	@ApiModelProperty(value = "医院类型")
	private Integer hospitalType;

	@ApiModelProperty(value = "医院等级")
	private Integer hospitalGrade;

	@ApiModelProperty(value = "医院主页")
	private String homePage;

	@ApiModelProperty(value = "医院描述")
	private String hospitalDesc;

	@ApiModelProperty(value = "经度")
	private String hospitalLon;

	@ApiModelProperty(value = "纬度")
	private String hospitalLat;

	@ApiModelProperty(value = "医院位置")
	private String hospitalAddress;

	@ApiModelProperty(value = "医院联系电话")
	private String hospitalPhone;

	@ApiModelProperty(value = "上午门诊时间")
	private String am;

	@ApiModelProperty(value = "下午门诊时间")
	private String pm;
}
