package com.smart.hospital.common.pay.strategy.builder;

import com.smart.hospital.common.pay.strategy.factory.StrategyFactory;
import com.smart.hospital.common.pay.strategy.factory.StrategyHandlerFactory;
import com.smart.hospital.common.pay.strategy.handler.StrategyHandler;

import java.util.ArrayList;
import java.util.List;

public class PayHandlerFactoryBuilder implements HandlerFactoryBuilder {

	private List<StrategyHandler> strategyHandlers = new ArrayList<>();

	public PayHandlerFactoryBuilder() {
	}

	public PayHandlerFactoryBuilder(List<StrategyHandler> strategyHandlers) {
		if (strategyHandlers != null && !strategyHandlers.isEmpty()) {
			this.strategyHandlers.addAll(strategyHandlers);
		}
	}

	@Override
	public StrategyFactory build() {
		return new StrategyHandlerFactory(strategyHandlers);
	}

	public void addStrategyHandler(StrategyHandler handler) {
		strategyHandlers.add(handler);
	}

	public List<StrategyHandler> getStrategyHandlers() {
		return strategyHandlers;
	}

	public void setStrategyHandlers(List<StrategyHandler> strategyHandlers) {
		this.strategyHandlers = strategyHandlers;
	}
}
