package com.smart.hospital.common.pay.strategy;

import com.smart.hospital.common.pay.exception.NoApplyHandlerException;
import com.smart.hospital.common.pay.exception.PayException;
import com.smart.hospital.common.pay.source.PayAttribute;
import com.smart.hospital.common.pay.strategy.handler.StrategyHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;

import java.lang.reflect.Method;

import static org.springframework.util.Assert.notNull;

@Slf4j
public class PayStrategyManager extends AbstractPayStrategy implements InitializingBean {

	@Override
	public Object doExecute(PayAttribute attribute, Class<?> clientInterface, Method method, Object[] args) {
		StrategyHandler handler = getHandler(attribute);
		if (handler != null) {
			if (args != null && args.length > 0) {
				for (int i = 0; i < args.length; i++) {
					Object arg = args[i];
					if (!check(arg)) {
						throw new PayException("参数错误!");
					}
					args[i] = wrap(clientInterface, method, args[i]);
				}
			}
			handler.beforeExecute(attribute, clientInterface, method, args);
			Object result = null;
			try {
				result = handler.execute(attribute, args);
			} catch (Exception e) {
				// 4.异常处理
				log.info("调用支付下单接口出现异常:{}", e.getLocalizedMessage());
				handler.exception(attribute, clientInterface, method, args, e);
				throw new PayException("支付异常 : " + e.getLocalizedMessage());
			}
			handler.afterExecute(attribute, clientInterface, method, args, result);
			return result;
		}
		throw new NoApplyHandlerException("No StrategyHandler for method ： " + method.getName());
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		notNull(getFactoryBuilder(), "Property 'HandlerFactoryBuilder' are required");
	}


}
