package com.smart.hospital.common.pay.strategy;

import com.smart.hospital.common.pay.source.PayAttribute;
import com.smart.hospital.common.pay.strategy.handler.StrategyHandler;

import java.lang.reflect.Method;

/**
 * 支付策略
 */
public interface PayStrategy {

	/**
	 * 获取执行策略
	 *
	 * @param attribute
	 * @return
	 */
	StrategyHandler getHandler(PayAttribute attribute);

	/**
	 * 参数解析
	 *
	 * @return
	 */
	Object wrap(Class<?> clientInterface, Method method, Object arg);

	/**
	 * 执行逻辑
	 *
	 * @param attribute
	 * @param clientInterface
	 * @param method
	 * @param args
	 * @return
	 */
	Object doExecute(PayAttribute attribute, Class<?> clientInterface, Method method, Object[] args);


}
