package com.smart.hospital.common.pay.source;

import com.smart.hospital.common.pay.parser.DefaultPayAnnotationParser;
import com.smart.hospital.common.pay.parser.PayAnnotationParser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AnnotationPayAttributeSource extends AbstractPayAttributeSource {

	/**
	 * 委托的注解解析器
	 */
	private List<PayAnnotationParser> annotationParsers = new ArrayList<>();

	public AnnotationPayAttributeSource(List<PayAnnotationParser> annotationParsers) {
		if (annotationParsers == null || annotationParsers.isEmpty()) {
			this.annotationParsers.add(new DefaultPayAnnotationParser());
		}
		this.annotationParsers = annotationParsers;
	}

	@Override
	protected PayAttribute findPayAttribute(Method method) {
		for (PayAnnotationParser parser : annotationParsers) {
			PayAttribute attr = parser.parsePayAnnotation(method);
			if (attr != null) {
				return attr;
			}
		}
		return null;
	}
}
