package com.smart.hospital.common.pay.parser;

import com.smart.hospital.common.pay.enums.*;
import com.smart.hospital.common.pay.source.DefaultPayAttribute;
import com.smart.hospital.common.pay.source.PayAttribute;
import org.springframework.core.annotation.AnnotationAttributes;

public class DefaultPayAnnotationParser extends AbstractPayAnnotationParser {

	@Override
	protected PayAttribute parsePayAnnotation(AnnotationAttributes attributes) {
		// 支付方式
		PaymentMethod paymentMethod = attributes.getEnum(PAYMENT_METHOD_NAME);
		// 支付版本号
		String version = attributes.getString(VERSION_NAME);
		// 请求路径前缀
		Domain prefix = null;
		if (attributes.containsKey(URL_PREFIX_NAME)) {
			prefix = attributes.getEnum(URL_PREFIX_NAME);
		}
		// 请求路径前缀
		Uri suffix = null;
		if (attributes.containsKey(URL_SUFFIX_NAME)) {
			suffix = attributes.getEnum(URL_SUFFIX_NAME);
		}
		// 请求方式
		RequestMethod requestMethod = attributes.getEnum(REQUEST_METHOD_NAME);
		// 商户平台模式
		PayModel model = attributes.getEnum(MODEL_NAME);
		return new DefaultPayAttribute(paymentMethod, version, prefix, suffix, requestMethod, model);
	}
}
