package com.smart.hospital.common.pay.model;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.StrUtil;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class WxHttpResponse implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 响应体
	 */
	private String body;

	/**
	 * 响应状态
	 */
	private int status;

	/**
	 * 响应头
	 */
	private Map<String, List<String>> headers;

	public WxHttpResponse() {
	}

	public WxHttpResponse(String body, int status, Map<String, List<String>> headers) {
		this.body = body;
		this.status = status;
		this.headers = headers;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public Map<String, List<String>> getHeaders() {
		return headers;
	}

	public void setHeaders(Map<String, List<String>> headers) {
		this.headers = headers;
	}

	public String getHeader(String name) {
		List<String> values = this.headerList(name);
		return CollectionUtil.isEmpty(values) ? null : values.get(0);
	}

	private List<String> headerList(String name) {
		if (StrUtil.isBlank(name)) {
			return null;
		} else {
			CaseInsensitiveMap<String, List<String>> headersIgnoreCase = new CaseInsensitiveMap<>(getHeaders());
			return headersIgnoreCase.get(name.trim());
		}
	}

	@Override
	public String toString() {
		return "WxHttpResponse{" +
				"body='" + body + '\'' +
				", status=" + status +
				", headers=" + headers +
				'}';
	}
}
