package com.smart.hospital.common.pay.factory;

import com.smart.hospital.common.pay.source.PayAttributeSource;
import com.smart.hospital.common.pay.strategy.PayStrategy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import static org.springframework.util.Assert.notNull;

public abstract class PayFactoryBeanSupport implements InitializingBean, ApplicationContextAware {

	ApplicationContext applicationContext;

	/**
	 * 资源解析器
	 */
	private PayAttributeSource payAttributeSource;

	/**
	 * 支付策略
	 */
	private PayStrategy payStrategy;

	public PayAttributeSource getPayAttributeSource() {
		return payAttributeSource;
	}

	public void setPayAttributeSource(PayAttributeSource payAttributeSource) {
		this.payAttributeSource = payAttributeSource;
	}

	public PayStrategy getPayStrategy() {
		return payStrategy;
	}

	public void setPayStrategy(PayStrategy payStrategy) {
		this.payStrategy = payStrategy;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
//		notNull(this.payAttributeSource, "Property 'payAttributeSource' are required");
		if (this.payAttributeSource == null) {
			this.payAttributeSource = applicationContext.getBean(PayAttributeSource.class);
			notNull(this.payAttributeSource, "Property 'payAttributeSource' are required");
		}
		if (this.payStrategy == null) {
			this.payStrategy = applicationContext.getBean(PayStrategy.class);
		}
	}
}
