package com.smart.hospital.common.pay.config;

import com.smart.hospital.common.pay.annotation.ClientScan;
import com.smart.hospital.common.pay.source.PayAttributeSource;
import com.smart.hospital.common.pay.strategy.PayStrategy;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class PayClientBeanDefinitionRegister implements ImportBeanDefinitionRegistrar {

	private PayAttributeSource payAttributeSource;

	private PayStrategy payStrategyManager;

	@Override
	public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
		AnnotationAttributes mapperScanAttrs = AnnotationAttributes
				.fromMap(importingClassMetadata.getAnnotationAttributes(ClientScan.class.getName()));
		if (mapperScanAttrs != null) {
			registerBeanDefinitions(mapperScanAttrs, registry);
		}
	}

	void registerBeanDefinitions(AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry) {
		List<String> basePackages = Arrays.stream(annoAttrs.getStringArray("basePackages"))
				.filter(StringUtils::hasText).collect(Collectors.toList());
		PayClientRegistryScanner scanner = new PayClientRegistryScanner(registry);
		scanner.setPayAttributeSource(payAttributeSource);
		scanner.setPayStrategy(payStrategyManager);
		scanner.registerFilters();
		scanner.scan(StringUtils.toStringArray(basePackages));
	}

	public PayAttributeSource getPayAttributeSource() {
		return payAttributeSource;
	}

	public void setPayAttributeSource(PayAttributeSource payAttributeSource) {
		this.payAttributeSource = payAttributeSource;
	}

	public PayStrategy getPayStrategyManager() {
		return payStrategyManager;
	}

	public void setPayStrategyManager(PayStrategy payStrategyManager) {
		this.payStrategyManager = payStrategyManager;
	}
}
