package com.smart.hospital.common.pay.client;

import com.alipay.api.AlipayResponse;
import com.smart.hospital.common.pay.annotation.ALI;
import com.smart.hospital.common.pay.annotation.WX;
import com.smart.hospital.common.pay.constant.Version;
import com.smart.hospital.common.pay.enums.PaymentMethod;
import com.smart.hospital.common.pay.enums.Domain;
import com.smart.hospital.common.pay.enums.RequestMethod;
import com.smart.hospital.common.pay.enums.Uri;
import com.smart.hospital.common.pay.model.*;
import org.springframework.http.HttpMethod;

/**
 * 支付客户端
 */
public interface PayClient {

	@WX(prefix = Domain.CHINA, suffix = Uri.JS_API_PAY, version = Version.WX_V3, method = RequestMethod.POST, payment = PaymentMethod.WX_JSAPI)
	String wxJsapiPay(WxUnifiedOrderModel model);

	@WX(prefix = Domain.CHINA, suffix = Uri.REFUND, version = Version.WX_V3, method = RequestMethod.POST, payment = PaymentMethod.WX_REFUND)
	String wxRefund(WxRefundModel model);

	@WX(prefix = Domain.CHINA, suffix = Uri.GET_CERTIFICATES, version = Version.WX_V3, payment = PaymentMethod.WX_CERT, method = RequestMethod.GET)
	WxHttpResponse wxPlatformCert();

	@ALI(method = HttpMethod.POST, payment = PaymentMethod.ALI_WEB)
	<T extends AlipayResponse> T aliWebPay(AliUnifiedOrderModel<?> model);

}
