package com.smart.hospital.common.pay.annotation;

import com.smart.hospital.common.pay.constant.Version;
import com.smart.hospital.common.pay.enums.PaymentMethod;
import org.springframework.http.HttpMethod;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 支付支付
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ALI {

	/**
	 * 支付方式
	 *
	 * @return
	 */
	PaymentMethod payment() default PaymentMethod.ALI_WEB;

	/**
	 * 版本
	 *
	 * @return
	 */
	String version() default Version.ALI_1_0;

	/**
	 * 请求地址
	 *
	 * @return
	 */
//	String url() default "";

	/**
	 * 请求方式
	 *
	 * @return
	 */
	HttpMethod method() default HttpMethod.POST;

}
