package com.smart.hospital.common.mq.handler.returns;

import com.smart.hospital.common.mq.domin.DefaultMessage;
import com.smart.hospital.common.mq.enums.DeliverStatus;
import com.smart.hospital.common.mq.handler.MessageContentHandler;
import com.smart.hospital.common.mq.handler.ReturnCallbackHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;

/**
 * Exchange -> Queue 投递失败
 */
@Slf4j
public class DefaultReturnCallbackHandler implements ReturnCallbackHandler {

	private MessageContentHandler messageContentHandler;

	public DefaultReturnCallbackHandler(MessageContentHandler messageContentHandler) {
		this.messageContentHandler = messageContentHandler;
	}

	@Override
	public Object returnCallback(Message message, int replyCode, String replyText, String exchange, String routingKey) {
		log.info("消息从Exchange路由到Queue失败: exchange: {}, route: {}, replyCode: {}, replyText: {}, message: {}", exchange, routingKey, replyCode, replyText, message);
		String correlationId = message.getMessageProperties().getCorrelationId();
		DefaultMessage defaultMessage = (DefaultMessage) messageContentHandler.getMessage(exchange, routingKey, correlationId);
		defaultMessage.setDeliverStatus(DeliverStatus.DELIVER_QUEUE_FAIL.getCode());
		return defaultMessage;
	}
}
