package com.smart.hospital.common.mq.handler.holder;

import cn.hutool.core.util.StrUtil;
import com.smart.hospital.common.mq.domin.DefaultMessage;
import com.smart.hospital.common.mq.handler.MessageContentHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultMessageContentHandler implements MessageContentHandler {

	private final Map<String, DefaultMessage> msgMap = new ConcurrentHashMap<>(64);

	@Override
	public Object addMessage(String exchange, String routingKey, Object message, String id, Integer code) {
		if (StrUtil.isNotBlank(id)) {
			return msgMap.put(id, new DefaultMessage(message, exchange, routingKey, code));
		}
		return null;
	}

	@Override
	public Object getMessage(String exchange, String routingKey, String id) {
		if (StrUtil.isNotBlank(id)) {
			return msgMap.get(id);
		}
		return null;
	}

	@Override
	public Object delMessage(String exchange, String routingKey, String id) {
		if (StrUtil.isNotBlank(id)) {
			return msgMap.remove(id);
		}
		return null;
	}

	public List<DefaultMessage> getAllMessages(){
		List<DefaultMessage> infos = new ArrayList<>(16);
		msgMap.forEach((k,v) -> {
			infos.add(v);
		});
		return infos;
	}
}
