package com.smart.hospital.common.mq.handler;

import org.springframework.amqp.rabbit.connection.CorrelationData;

/**
 * 消息内容处理器
 *
 * @param //<KEY> 存储的key
 * @param //<MSG> 存储的消息
 */
public interface MessageContentHandler {

	/**
	 * 放入消息
	 *
	 * @param exchange   交换机
	 * @param routingKey 路由键
	 * @param message    消息内容
	 * @param id   标识消息的唯一ID
	 * @param code       消息发送状态  DeliverStatus
	 * @return
	 */
	Object addMessage(String exchange, String routingKey, Object message, String id, Integer code);

	/**
	 * 获取消息
	 *
	 * @param exchange
	 * @param routingKey
	 * @param id
	 * @return
	 */
	Object getMessage(String exchange, String routingKey, String id);

	/**
	 * 删除消息
	 *
	 * @param exchange
	 * @param routingKey
	 * @param id
	 * @return
	 */
	Object delMessage(String exchange, String routingKey, String id);
}
