package com.smart.hospital.common.mq.handler;

import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.lang.Nullable;

/**
 * 消息发送到交换机Exchange成功/失败处理器
 */
public interface ConfirmCallbackHandler {

	/**
	 * Confirmation callback.
	 *
	 * @param correlationData correlation data for the callback.
	 * @param ack             true for ack, false for nack
	 * @param cause           An optional cause, for nack, when available, otherwise null.
	 * @return
	 */
	Object confirmCallback(@Nullable CorrelationData correlationData, boolean ack, @Nullable String cause);
}
