package com.smart.hospital.common.mq.factory;

import org.springframework.beans.factory.FactoryBean;

public class ClientFactoryBean<T> extends RabbitTemplateSupport implements FactoryBean<T> {

	private Class<T> clientInterface;

	public ClientFactoryBean() {
	}

	public ClientFactoryBean(Class<T> clientInterface) {
		this.clientInterface = clientInterface;
	}

	@Override
	public T getObject() throws Exception {
		return registerClient();
	}

	@Override
	public Class<T> getObjectType() {
		return this.clientInterface;
	}


	@Override
	public boolean isSingleton() {
		return true;
	}

	/**
	 * 创建代理对象
	 *
	 * @return
	 */
	private T registerClient() {
		ClientProxyFactory<T> factory = new ClientProxyFactory<>(this.clientInterface);
		return factory.newInstance(rabbitTemplate, messageContentHandler);
	}

	public Class<T> getClientInterface() {
		return clientInterface;
	}

	public void setClientInterface(Class<T> clientInterface) {
		this.clientInterface = clientInterface;
	}

}
